library "lib/download.brs"
library "lib/checksum.brs"
library "lib/install.brs"

sub Main()
  print "BrightSign / Nowsignage"

  m.update_endpoint = "https://cdn.nowsignage.com/brightsign/5.2.51"
  m.version = "main~86b242d"

  m.port = CreateObject("roMessagePort")

  videoMode = CreateObject("roVideoMode")
  width = videoMode.GetResX()
  height = videoMode.GetResY()

  screen = CreateObject("roRectangle", 0, 0, width, height)

  url = "file:///sd:/client/index.html"
  pin = GetScreenPin()
  if pin <> Invalid
    url = url + "?pin=" + pin
  end if

  reg = CreateObject("roregistrysection", "html")
  reg.Write("use-brightsign-media-player", "0")
  reg.Flush()

  config = {
    inspector_server: { port: 2999 },
    url: url,
    brightsign_js_objects_enabled: true,
    storage_path: "SD:/storage",
    storage_quota: "8589934592",
    hwz_default: "on"
  }

  m.htmlWidget = CreateObject("roHtmlWidget", screen, config)
  m.htmlWidget.SetPort(m.port)
  m.htmlWidget.Show()

  while true
    event = Wait(0, m.port)

    if type(event) = "roHtmlWidgetEvent"
      payload = event.GetData()

      if payload.reason = "message"
        HandleMessage(payload.message)
      end if
    end if
  end while
end sub

sub HandleMessage(message)
  if message.action = "perform_reboot"
    PerformReboot()
  elseif message.action = "perform_upgrade"
    PerformUpgrade()
  end if
end sub

sub PerformUpgrade()
  data = GetLatestVersionInfo(m.update_endpoint)
  if data <> Invalid
    if m.version = data.version
      SendMessage("perform_upgrade", "already_latest")

      return
    end if

    SendMessage("perform_upgrade", "start")

    CreateFileFromUrl(m.update_endpoint + "/autorun.zip", "sd:/update.zip")

    if HasValidChecksum("sd:/update.zip", data.checksum)
      PerformInstallation()
      SendMessage("perform_upgrade", "complete")

      Sleep(5000)

      RebootSystem()
    else
      DeleteFile("sd:/update.zip")

      SendMessage("perform_upgrade", "invalid_file")
    end if
  else
    SendMessage("perform_upgrade", "server_unreachable")
  end if
end sub

sub PerformReboot()
  SendMessage("perform_reboot", "complete")
  Sleep(2500)
  RebootSystem()
end sub

sub SendMessage(action, status)
  m.htmlWidget.PostJSMessage({
    action: action,
    status: status
  })
end sub
