function HasValidChecksum(filePath, expectedChecksum)
  checksum = GetChecksum(filePath)

  return LCase(checksum) = LCase(expectedChecksum)
end function

function GetChecksum(filePath)
  byteArray = CreateObject("roByteArray")
  byteArray.ReadFile(filePath)
  hashGenerator = CreateObject("roHashGenerator", "SHA256")

  return hashGenerator.hash(byteArray).ToHexString()
end function
