function GetLatestVersionInfo(baseUrl)
  data = GetStringFromUrl(baseUrl + "/version.json", 2000)

  if data = Invalid
    return Invalid
  end if

  return ParseJson(data)
end function

sub CreateFileFromUrl(url, filePath)
  urlTransfer = CreateObject("roURLTransfer")
  urlTransfer.SetURL(url)
  urlTransfer.SetPort(m.port)

  urlTransfer.GetToFile(filePath)
end sub

function GetStringFromUrl(url, timeout)
  urlTransfer = CreateObject("roURLTransfer")
  urlTransfer.SetURL(url)
  urlTransfer.SetPort(m.port)

  if urlTransfer.AsyncGetToString()
    event = Wait(timeout, m.port)

    if type(event) = "roUrlEvent"
      return event.GetString()
    elseif event = Invalid
      urlTransfer.AsyncCancel()
    end if
  end if

  return Invalid
end function
